import pygame

def fit(surf,size,meth="smooth"):
    origwidth, origheight = surf.get_rect().size
    swidth, sheight = size
    widthratio = swidth/origwidth
    heightratio = sheight/origheight
    if meth == "smoothint":
        swidthratio = widthratio
        sheightratio = heightratio
        widthratio = round(widthratio)
        heightratio = round(heightratio)
    if heightratio < widthratio:
        imgwidth = int(origwidth*heightratio)
        imgheight = int(origheight*heightratio)
    else:
        imgwidth = int(origwidth*widthratio)
        imgheight = int(origheight*widthratio)
    if   meth == "smooth":
        return pygame.transform.smoothscale(surf, [imgwidth, imgheight])
    elif meth in "nearest":
        return pygame.transform.scale(surf, [imgwidth, imgheight])
    elif meth == "smoothint":
        if imgwidth and imgheight:
            surf = pygame.transform.scale(surf, [imgwidth, imgheight])
        if sheightratio < swidthratio:
            imgwidth = int(origwidth*sheightratio)
            imgheight = int(origheight*sheightratio)
        else:
            imgwidth = int(origwidth*swidthratio)
            imgheight = int(origheight*swidthratio)
        return pygame.transform.smoothscale(surf, [imgwidth, imgheight])

def fill(surf,size,meth="smooth"):
    origwidth, origheight = surf.get_rect().size
    swidth, sheight = size
    widthratio = swidth/origwidth
    heightratio = sheight/origheight
    if meth == "smoothint":
        swidthratio = widthratio
        sheightratio = heightratio
        widthratio = round(widthratio)
        heightratio = round(heightratio)
    if heightratio > widthratio:
        imgwidth = int(origwidth*heightratio)
        imgheight = int(origheight*heightratio)
    else:
        imgwidth = int(origwidth*widthratio)
        imgheight = int(origheight*widthratio)
    if   meth == "smooth":
        return pygame.transform.smoothscale(surf, [imgwidth, imgheight])
    elif meth in "nearest":
        return pygame.transform.scale(surf, [imgwidth, imgheight])
    elif meth == "smoothint":
        if imgwidth and imgheight:
            surf = pygame.transform.scale(surf, [imgwidth, imgheight])
        if sheightratio > swidthratio:
            imgwidth = int(origwidth*sheightratio)
            imgheight = int(origheight*sheightratio)
        else:
            imgwidth = int(origwidth*swidthratio)
            imgheight = int(origheight*swidthratio)
        return pygame.transform.smoothscale(surf, [imgwidth, imgheight])
