import threading # other imports
import queue
from time import sleep

import pygame # pygame setup
pygame.init()
FPS = 60
fntlaysize = (32,8)
screensize = (80,25)

import surfscale # internal screen setup
def goodscale(scr,window):
    size = scr.get_size()
    if size[0]/4 > size[1]/3:
        size = (size[0],size[0]/4*3)
    else:
        size = (size[1],size[1]/3*4)
    img = surfscale.fit(pygame.transform.smoothscale(scr,size),window.get_size())
    pos = window.get_size()
    size = img.get_size()
    pos = ((pos[0]-size[0])/2, (pos[1]-size[1])/2)
    return img,pos
def loadfont(font):
    global tiles,h,w,screen
    img = pygame.image.load(font+".png")
    h,w = int(img.get_height()/fntlaysize[1]),int(img.get_width()/fntlaysize[0])
    screen = pygame.Surface((w*screensize[0],h*screensize[1]))
    tiles = []
    for ty in range(8):
        for tx in range(32):
            tiles.append([])
            for y in range(int(img.get_height()/fntlaysize[1])):
                tiles[-1].append([])
                for x in range(int(img.get_width()/fntlaysize[0])):
                    tiles[-1][-1].append(bool(img.get_at((x+tx*w,y+ty*h))[0]))
    i = 0
    for tile in tiles:
        tiles[i] = pygame.Surface((len(tile[0]),len(tile)))
        for y in range(len(tile)):
            for x in range(len(tile[y])):
                if tile[y][x]:
                    tiles[i].set_at((x,y),(255,255,255))
                else:
                    tiles[i].set_at((x,y),(0,0,0))
        i += 1
loadfont("cga")

with open("chars.txt",encoding="utf-8") as f: # character to number stuff
    f = f.read().replace("\n","")
charnum = {}
for i in range(len(f)):
    charnum.update({f[i]:i})

palette = [ # colouuuuurs (colours)
    {False:(0  ,0  ,0  ),True:(85 ,85 ,85 )},
    {False:(170,0  ,0  ),True:(255,85 ,85 )},
    {False:(0  ,170,0  ),True:(85 ,255,85 )},
    {False:(170,85 ,0  ),True:(255,255,85 )},
    {False:(0  ,0  ,170),True:(85 ,85 ,255)},
    {False:(170,0  ,170),True:(255,85 ,255)},
    {False:(0  ,170,170),True:(85 ,255,255)},
    {False:(170,170,170),True:(255,255,255)}]
class Colors:
    def reset(self):
        self.fg_color = 7
        self.fg_brightness = False
        self.bg_color = 0
        self.bg_brightness = False
def colorize(surf,fg,bg):
    surf = surf.copy()
    nsurf = pygame.Surface(surf.get_size())
    nsurf.fill(bg)
    surf.set_colorkey((0,0,0))
    nsurf.blit(surf,(0,0))
    fsurf = pygame.Surface(surf.get_size())
    fsurf.fill(fg)
    nsurf.set_colorkey((255,255,255))
    fsurf.blit(nsurf,(0,0))
    return fsurf
class Loop:
    def drawtile(self,n,pos,colors):
        x,y = pos
        try:
            screen.blit(colorize(tiles[n],palette[colors.fg_color][colors.fg_brightness],palette[colors.bg_color][colors.bg_brightness]),(w*x,h*y))
        except IndexError:
            screen.blit(colorize(tiles[0],palette[colors.fg_color][colors.fg_brightness],palette[colors.bg_color][colors.bg_brightness]),(w*x,h*y))

    # starting loop
    def screenloop(self,text,events,redraw,close,draw_fps):
        window = pygame.display.set_mode((480,360),pygame.RESIZABLE)
        clock = pygame.time.Clock()
        fpsfont = pygame.font.SysFont("Impact",16)
        escape = False
        escseq = ""
        colors = Colors()
        colors.reset()
        oldtext = ""
        try:
            while True:
                if close[0]:
                    pygame.display.quit()
                    raise SystemExit
                for event in pygame.event.get():
                    events.put(event)
                if oldtext != text[0]:
                    redraw[0] = True
                    oldtext = text[0]
                if redraw[0]:
                    screen.fill((0,0,0))
                    x = 0
                    y = 0
                    for char in text[0]:
                        if char == "\n":
                            while x < screensize[0]:
                                self.drawtile(32,(x,y))
                                x += 1
                            y += 1
                            x = 0
                        elif char == "\x1b":
                            escape = True
                        elif escape and char == "m":
                            escape = False
                            escseq = escseq[1:].split(";")
                            for i in range(len(escseq)):
                                escseq[i] = int(escseq[i])
                                if   escseq[i] == 0: # reset
                                    colors.reset()
                                elif escseq[i] == 1: # bright fg
                                    colors.fg_brightness = True
                                elif escseq[i] == 22: # standard fg
                                    colors.fg_brightness = False
                                elif 29 < escseq[i] < 38: # fg colours
                                    colors.fg_color = escseq[i]-30
                                elif 39 < escseq[i] < 48: # bg colours
                                    colors.bg_color = escseq[i]-40
                                    colors.bg_brightness = False
                                #elif 89 < escseq[i] < 98: # bright fg colours (aixterm)
                                #    colors.fg_color = escseq[i]-30
                                #    colors.fg_brightness = True
                                elif 99 < escseq[i] < 108: # bright bg colours (aixterm)
                                    colors.bg_color = escseq[i]-40
                                    colors.bg_brightness = True
                                else:
                                    print("What")
                                    close[0] = True
                            escseq = ""
                        elif escape:
                            escseq = escseq + char
                        elif not escape:
                            self.drawtile(charnum[char],(x,y),colors)
                            x += 1
                    if escape:
                        escape = False
                        self.drawtile(255,(x,y),colors)
                    g = goodscale(screen,window)
                    redraw[0] = False
                window.fill((0,0,0))
                window.blit(g[0],g[1])
                window.blit(fpsfont.render(str(round(clock.get_fps())),True,(255,0,0)),(0,0))
                pygame.display.flip()
                clock.tick()
                pygame.time.delay(1000//FPS)
        finally:
            pygame.quit()
loop = Loop()

if __name__ == "__main__":
    txt = ["hejewwo :3"]
    events = queue.Queue()
    redraw = [True]
    close = [False]
    draw_fps = [False]
    t = threading.Thread(target=loop.screenloop,args=(txt,events,redraw,close,draw_fps))
    t.daemon = True
    t.start()
    x = 0
    while True:
        #txt[0] = str(x)
        if not events.empty():
            for _ in range(events.qsize()):
                event = events.get()
                #print(event)
                if   event.type == pygame.QUIT or (event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE):
                    close[0] = True
                    raise SystemExit
                elif event.type == pygame.VIDEORESIZE:
                    redraw[0] = True
                elif event.type == pygame.KEYDOWN:
                    if event.unicode in charnum:
                        txt[0] = (event.unicode * 80 + "\n")*25
                    else:
                        txt[0] = ("🬀" * 80 + "\n")*25
        #x += 1
        sleep(0.1)
